%------------------------------------------------------------------------------
% File     : ITP195^1 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Sturm_Tarski problem prob_450__5874512_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Sturm_Tarski/prob_450__5874512_1 [Des21]

% Status   : Theorem
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.30 v8.2.0, 0.15 v8.1.0, 0.18 v7.5.0
% Syntax   : Number of formulae    :  424 ( 156 unt;  78 typ;   0 def)
%            Number of atoms       : 1005 ( 321 equ;   0 cnn)
%            Maximal formula atoms :   12 (   2 avg)
%            Number of connectives : 2572 ( 149   ~;  32   |;  37   &;1859   @)
%                                         (   0 <=>; 495  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   7 avg)
%            Number of types       :   12 (  11 usr)
%            Number of type conns  :  168 ( 168   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   68 (  67 usr;  13 con; 0-3 aty)
%            Number of variables   :  923 (  53   ^; 841   !;  29   ?; 923   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 15:42:23.162
%------------------------------------------------------------------------------
% Could-be-implicit typings (11)
thf(ty_n_t__Polynomial__Opoly_It__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J_J,type,
    poly_poly_poly_real: $tType ).

thf(ty_n_t__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J,type,
    poly_poly_real: $tType ).

thf(ty_n_t__Polynomial__Opoly_It__Polynomial__Opoly_It__Nat__Onat_J_J,type,
    poly_poly_nat: $tType ).

thf(ty_n_t__Polynomial__Opoly_It__Polynomial__Opoly_It__Int__Oint_J_J,type,
    poly_poly_int: $tType ).

thf(ty_n_t__Polynomial__Opoly_It__Real__Oreal_J,type,
    poly_real: $tType ).

thf(ty_n_t__Polynomial__Opoly_It__Nat__Onat_J,type,
    poly_nat: $tType ).

thf(ty_n_t__Polynomial__Opoly_It__Int__Oint_J,type,
    poly_int: $tType ).

thf(ty_n_t__Set__Oset_It__Real__Oreal_J,type,
    set_real: $tType ).

thf(ty_n_t__Real__Oreal,type,
    real: $tType ).

thf(ty_n_t__Nat__Onat,type,
    nat: $tType ).

thf(ty_n_t__Int__Oint,type,
    int: $tType ).

% Explicit typings (67)
thf(sy_c_Groups_Oone__class_Oone_001t__Nat__Onat,type,
    one_one_nat: nat ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Int__Oint,type,
    zero_zero_int: int ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Nat__Onat,type,
    zero_zero_nat: nat ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Polynomial__Opoly_It__Int__Oint_J,type,
    zero_zero_poly_int: poly_int ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Polynomial__Opoly_It__Nat__Onat_J,type,
    zero_zero_poly_nat: poly_nat ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Int__Oint_J_J,type,
    zero_z1549157189ly_int: poly_poly_int ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Nat__Onat_J_J,type,
    zero_z1059985641ly_nat: poly_poly_nat ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J_J,type,
    zero_z935034829y_real: poly_poly_poly_real ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J,type,
    zero_z1423781445y_real: poly_poly_real ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    zero_zero_poly_real: poly_real ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Real__Oreal,type,
    zero_zero_real: real ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Int__Oint,type,
    ord_less_int: int > int > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Nat__Onat,type,
    ord_less_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Polynomial__Opoly_It__Int__Oint_J,type,
    ord_less_poly_int: poly_int > poly_int > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J,type,
    ord_le38482960y_real: poly_poly_real > poly_poly_real > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    ord_less_poly_real: poly_real > poly_real > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Real__Oreal,type,
    ord_less_real: real > real > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Int__Oint,type,
    ord_less_eq_int: int > int > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Nat__Onat,type,
    ord_less_eq_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Polynomial__Opoly_It__Int__Oint_J,type,
    ord_less_eq_poly_int: poly_int > poly_int > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J,type,
    ord_le893774876y_real: poly_poly_real > poly_poly_real > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    ord_le1180086932y_real: poly_real > poly_real > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Real__Oreal,type,
    ord_less_eq_real: real > real > $o ).

thf(sy_c_Polynomial_Ois__zero_001t__Int__Oint,type,
    is_zero_int: poly_int > $o ).

thf(sy_c_Polynomial_Ois__zero_001t__Nat__Onat,type,
    is_zero_nat: poly_nat > $o ).

thf(sy_c_Polynomial_Ois__zero_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    is_zero_poly_real: poly_poly_real > $o ).

thf(sy_c_Polynomial_Ois__zero_001t__Real__Oreal,type,
    is_zero_real: poly_real > $o ).

thf(sy_c_Polynomial_Oorder_001t__Int__Oint,type,
    order_int: int > poly_int > nat ).

thf(sy_c_Polynomial_Oorder_001t__Polynomial__Opoly_It__Int__Oint_J,type,
    order_poly_int: poly_int > poly_poly_int > nat ).

thf(sy_c_Polynomial_Oorder_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J,type,
    order_poly_poly_real: poly_poly_real > poly_poly_poly_real > nat ).

thf(sy_c_Polynomial_Oorder_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    order_poly_real: poly_real > poly_poly_real > nat ).

thf(sy_c_Polynomial_Oorder_001t__Real__Oreal,type,
    order_real: real > poly_real > nat ).

thf(sy_c_Polynomial_Opderiv_001t__Int__Oint,type,
    pderiv_int: poly_int > poly_int ).

thf(sy_c_Polynomial_Opderiv_001t__Nat__Onat,type,
    pderiv_nat: poly_nat > poly_nat ).

thf(sy_c_Polynomial_Opderiv_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    pderiv_poly_real: poly_poly_real > poly_poly_real ).

thf(sy_c_Polynomial_Opderiv_001t__Real__Oreal,type,
    pderiv_real: poly_real > poly_real ).

thf(sy_c_Polynomial_Opoly_001t__Int__Oint,type,
    poly_int2: poly_int > int > int ).

thf(sy_c_Polynomial_Opoly_001t__Nat__Onat,type,
    poly_nat2: poly_nat > nat > nat ).

thf(sy_c_Polynomial_Opoly_001t__Polynomial__Opoly_It__Int__Oint_J,type,
    poly_poly_int2: poly_poly_int > poly_int > poly_int ).

thf(sy_c_Polynomial_Opoly_001t__Polynomial__Opoly_It__Nat__Onat_J,type,
    poly_poly_nat2: poly_poly_nat > poly_nat > poly_nat ).

thf(sy_c_Polynomial_Opoly_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J,type,
    poly_poly_poly_real2: poly_poly_poly_real > poly_poly_real > poly_poly_real ).

thf(sy_c_Polynomial_Opoly_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    poly_poly_real2: poly_poly_real > poly_real > poly_real ).

thf(sy_c_Polynomial_Opoly_001t__Real__Oreal,type,
    poly_real2: poly_real > real > real ).

thf(sy_c_Polynomial_Opoly__cutoff_001t__Int__Oint,type,
    poly_cutoff_int: nat > poly_int > poly_int ).

thf(sy_c_Polynomial_Opoly__cutoff_001t__Nat__Onat,type,
    poly_cutoff_nat: nat > poly_nat > poly_nat ).

thf(sy_c_Polynomial_Opoly__cutoff_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    poly_c1404107022y_real: nat > poly_poly_real > poly_poly_real ).

thf(sy_c_Polynomial_Opoly__cutoff_001t__Real__Oreal,type,
    poly_cutoff_real: nat > poly_real > poly_real ).

thf(sy_c_Polynomial_Opoly__shift_001t__Int__Oint,type,
    poly_shift_int: nat > poly_int > poly_int ).

thf(sy_c_Polynomial_Opoly__shift_001t__Nat__Onat,type,
    poly_shift_nat: nat > poly_nat > poly_nat ).

thf(sy_c_Polynomial_Opoly__shift_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    poly_shift_poly_real: nat > poly_poly_real > poly_poly_real ).

thf(sy_c_Polynomial_Opoly__shift_001t__Real__Oreal,type,
    poly_shift_real: nat > poly_real > poly_real ).

thf(sy_c_Polynomial_Oreflect__poly_001t__Int__Oint,type,
    reflect_poly_int: poly_int > poly_int ).

thf(sy_c_Polynomial_Oreflect__poly_001t__Nat__Onat,type,
    reflect_poly_nat: poly_nat > poly_nat ).

thf(sy_c_Polynomial_Oreflect__poly_001t__Polynomial__Opoly_It__Int__Oint_J,type,
    reflec943087998ly_int: poly_poly_int > poly_poly_int ).

thf(sy_c_Polynomial_Oreflect__poly_001t__Polynomial__Opoly_It__Nat__Onat_J,type,
    reflec781175074ly_nat: poly_poly_nat > poly_poly_nat ).

thf(sy_c_Polynomial_Oreflect__poly_001t__Polynomial__Opoly_It__Polynomial__Opoly_It__Real__Oreal_J_J,type,
    reflec144234502y_real: poly_poly_poly_real > poly_poly_poly_real ).

thf(sy_c_Polynomial_Oreflect__poly_001t__Polynomial__Opoly_It__Real__Oreal_J,type,
    reflec1522834046y_real: poly_poly_real > poly_poly_real ).

thf(sy_c_Polynomial_Oreflect__poly_001t__Real__Oreal,type,
    reflect_poly_real: poly_real > poly_real ).

thf(sy_c_Polynomial_Orsquarefree_001t__Real__Oreal,type,
    rsquarefree_real: poly_real > $o ).

thf(sy_c_Set_OCollect_001t__Real__Oreal,type,
    collect_real: ( real > $o ) > set_real ).

thf(sy_c_Sturm__Tarski__Mirabelle__skihomvtkj_Ocross,type,
    sturm_1953858694_cross: poly_real > real > real > int ).

thf(sy_c_Sturm__Tarski__Mirabelle__skihomvtkj_Osign__r__pos,type,
    sturm_469514713_r_pos: poly_real > real > $o ).

thf(sy_c_Sturm__Tarski__Mirabelle__skihomvtkj_Ovariation,type,
    sturm_1279781401iation: real > real > int ).

thf(sy_c_member_001t__Real__Oreal,type,
    member_real: real > set_real > $o ).

thf(sy_v_p,type,
    p: poly_real ).

thf(sy_v_x,type,
    x: real ).

% Relevant facts (345)
thf(fact_0_False,axiom,
    ( ( poly_real2 @ p @ x )
   != zero_zero_real ) ).

% False
thf(fact_1__092_060open_062sign__r__pos_Ap_Ax_A_092_060Longrightarrow_062_A0_A_060_Apoly_Ap_Ax_092_060close_062,axiom,
    ( ( sturm_469514713_r_pos @ p @ x )
   => ( ord_less_real @ zero_zero_real @ ( poly_real2 @ p @ x ) ) ) ).

% \<open>sign_r_pos p x \<Longrightarrow> 0 < poly p x\<close>
thf(fact_2__092_060open_0620_A_060_Apoly_Ap_Ax_A_092_060Longrightarrow_062_Asign__r__pos_Ap_Ax_092_060close_062,axiom,
    ( ( ord_less_real @ zero_zero_real @ ( poly_real2 @ p @ x ) )
   => ( sturm_469514713_r_pos @ p @ x ) ) ).

% \<open>0 < poly p x \<Longrightarrow> sign_r_pos p x\<close>
thf(fact_3_assms,axiom,
    p != zero_zero_poly_real ).

% assms
thf(fact_4_poly__0,axiom,
    ! [X: poly_nat] :
      ( ( poly_poly_nat2 @ zero_z1059985641ly_nat @ X )
      = zero_zero_poly_nat ) ).

% poly_0
thf(fact_5_poly__0,axiom,
    ! [X: poly_int] :
      ( ( poly_poly_int2 @ zero_z1549157189ly_int @ X )
      = zero_zero_poly_int ) ).

% poly_0
thf(fact_6_poly__0,axiom,
    ! [X: poly_poly_real] :
      ( ( poly_poly_poly_real2 @ zero_z935034829y_real @ X )
      = zero_z1423781445y_real ) ).

% poly_0
thf(fact_7_poly__0,axiom,
    ! [X: poly_real] :
      ( ( poly_poly_real2 @ zero_z1423781445y_real @ X )
      = zero_zero_poly_real ) ).

% poly_0
thf(fact_8_poly__0,axiom,
    ! [X: int] :
      ( ( poly_int2 @ zero_zero_poly_int @ X )
      = zero_zero_int ) ).

% poly_0
thf(fact_9_poly__0,axiom,
    ! [X: nat] :
      ( ( poly_nat2 @ zero_zero_poly_nat @ X )
      = zero_zero_nat ) ).

% poly_0
thf(fact_10_poly__0,axiom,
    ! [X: real] :
      ( ( poly_real2 @ zero_zero_poly_real @ X )
      = zero_zero_real ) ).

% poly_0
thf(fact_11_not__gr__zero,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less_nat @ zero_zero_nat @ N ) )
      = ( N = zero_zero_nat ) ) ).

% not_gr_zero
thf(fact_12_poly__IVT__neg,axiom,
    ! [A: real,B: real,P: poly_real] :
      ( ( ord_less_real @ A @ B )
     => ( ( ord_less_real @ zero_zero_real @ ( poly_real2 @ P @ A ) )
       => ( ( ord_less_real @ ( poly_real2 @ P @ B ) @ zero_zero_real )
         => ? [X2: real] :
              ( ( ord_less_real @ A @ X2 )
              & ( ord_less_real @ X2 @ B )
              & ( ( poly_real2 @ P @ X2 )
                = zero_zero_real ) ) ) ) ) ).

% poly_IVT_neg
thf(fact_13_poly__IVT__pos,axiom,
    ! [A: real,B: real,P: poly_real] :
      ( ( ord_less_real @ A @ B )
     => ( ( ord_less_real @ ( poly_real2 @ P @ A ) @ zero_zero_real )
       => ( ( ord_less_real @ zero_zero_real @ ( poly_real2 @ P @ B ) )
         => ? [X2: real] :
              ( ( ord_less_real @ A @ X2 )
              & ( ord_less_real @ X2 @ B )
              & ( ( poly_real2 @ P @ X2 )
                = zero_zero_real ) ) ) ) ) ).

% poly_IVT_pos
thf(fact_14_poly__all__0__iff__0,axiom,
    ! [P: poly_poly_int] :
      ( ( ! [X3: poly_int] :
            ( ( poly_poly_int2 @ P @ X3 )
            = zero_zero_poly_int ) )
      = ( P = zero_z1549157189ly_int ) ) ).

% poly_all_0_iff_0
thf(fact_15_poly__all__0__iff__0,axiom,
    ! [P: poly_poly_poly_real] :
      ( ( ! [X3: poly_poly_real] :
            ( ( poly_poly_poly_real2 @ P @ X3 )
            = zero_z1423781445y_real ) )
      = ( P = zero_z935034829y_real ) ) ).

% poly_all_0_iff_0
thf(fact_16_poly__all__0__iff__0,axiom,
    ! [P: poly_real] :
      ( ( ! [X3: real] :
            ( ( poly_real2 @ P @ X3 )
            = zero_zero_real ) )
      = ( P = zero_zero_poly_real ) ) ).

% poly_all_0_iff_0
thf(fact_17_poly__all__0__iff__0,axiom,
    ! [P: poly_poly_real] :
      ( ( ! [X3: poly_real] :
            ( ( poly_poly_real2 @ P @ X3 )
            = zero_zero_poly_real ) )
      = ( P = zero_z1423781445y_real ) ) ).

% poly_all_0_iff_0
thf(fact_18_poly__all__0__iff__0,axiom,
    ! [P: poly_int] :
      ( ( ! [X3: int] :
            ( ( poly_int2 @ P @ X3 )
            = zero_zero_int ) )
      = ( P = zero_zero_poly_int ) ) ).

% poly_all_0_iff_0
thf(fact_19_less__numeral__extra_I3_J,axiom,
    ~ ( ord_less_poly_real @ zero_zero_poly_real @ zero_zero_poly_real ) ).

% less_numeral_extra(3)
thf(fact_20_less__numeral__extra_I3_J,axiom,
    ~ ( ord_less_int @ zero_zero_int @ zero_zero_int ) ).

% less_numeral_extra(3)
thf(fact_21_less__numeral__extra_I3_J,axiom,
    ~ ( ord_less_poly_int @ zero_zero_poly_int @ zero_zero_poly_int ) ).

% less_numeral_extra(3)
thf(fact_22_less__numeral__extra_I3_J,axiom,
    ~ ( ord_le38482960y_real @ zero_z1423781445y_real @ zero_z1423781445y_real ) ).

% less_numeral_extra(3)
thf(fact_23_less__numeral__extra_I3_J,axiom,
    ~ ( ord_less_real @ zero_zero_real @ zero_zero_real ) ).

% less_numeral_extra(3)
thf(fact_24_less__numeral__extra_I3_J,axiom,
    ~ ( ord_less_nat @ zero_zero_nat @ zero_zero_nat ) ).

% less_numeral_extra(3)
thf(fact_25_field__lbound__gt__zero,axiom,
    ! [D1: real,D2: real] :
      ( ( ord_less_real @ zero_zero_real @ D1 )
     => ( ( ord_less_real @ zero_zero_real @ D2 )
       => ? [E: real] :
            ( ( ord_less_real @ zero_zero_real @ E )
            & ( ord_less_real @ E @ D1 )
            & ( ord_less_real @ E @ D2 ) ) ) ) ).

% field_lbound_gt_zero
thf(fact_26_gr__zeroI,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% gr_zeroI
thf(fact_27_not__less__zero,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% not_less_zero
thf(fact_28_gr__implies__not__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) ).

% gr_implies_not_zero
thf(fact_29_zero__less__iff__neq__zero,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
      = ( N != zero_zero_nat ) ) ).

% zero_less_iff_neq_zero
thf(fact_30_pderiv__0,axiom,
    ( ( pderiv_real @ zero_zero_poly_real )
    = zero_zero_poly_real ) ).

% pderiv_0
thf(fact_31_pderiv__0,axiom,
    ( ( pderiv_nat @ zero_zero_poly_nat )
    = zero_zero_poly_nat ) ).

% pderiv_0
thf(fact_32_pderiv__0,axiom,
    ( ( pderiv_int @ zero_zero_poly_int )
    = zero_zero_poly_int ) ).

% pderiv_0
thf(fact_33_pderiv__0,axiom,
    ( ( pderiv_poly_real @ zero_z1423781445y_real )
    = zero_z1423781445y_real ) ).

% pderiv_0
thf(fact_34_zero__reorient,axiom,
    ! [X: real] :
      ( ( zero_zero_real = X )
      = ( X = zero_zero_real ) ) ).

% zero_reorient
thf(fact_35_zero__reorient,axiom,
    ! [X: poly_real] :
      ( ( zero_zero_poly_real = X )
      = ( X = zero_zero_poly_real ) ) ).

% zero_reorient
thf(fact_36_zero__reorient,axiom,
    ! [X: int] :
      ( ( zero_zero_int = X )
      = ( X = zero_zero_int ) ) ).

% zero_reorient
thf(fact_37_zero__reorient,axiom,
    ! [X: nat] :
      ( ( zero_zero_nat = X )
      = ( X = zero_zero_nat ) ) ).

% zero_reorient
thf(fact_38_zero__reorient,axiom,
    ! [X: poly_nat] :
      ( ( zero_zero_poly_nat = X )
      = ( X = zero_zero_poly_nat ) ) ).

% zero_reorient
thf(fact_39_zero__reorient,axiom,
    ! [X: poly_int] :
      ( ( zero_zero_poly_int = X )
      = ( X = zero_zero_poly_int ) ) ).

% zero_reorient
thf(fact_40_zero__reorient,axiom,
    ! [X: poly_poly_real] :
      ( ( zero_z1423781445y_real = X )
      = ( X = zero_z1423781445y_real ) ) ).

% zero_reorient
thf(fact_41_poly__eq__poly__eq__iff,axiom,
    ! [P: poly_real,Q: poly_real] :
      ( ( ( poly_real2 @ P )
        = ( poly_real2 @ Q ) )
      = ( P = Q ) ) ).

% poly_eq_poly_eq_iff
thf(fact_42_poly__eq__poly__eq__iff,axiom,
    ! [P: poly_int,Q: poly_int] :
      ( ( ( poly_int2 @ P )
        = ( poly_int2 @ Q ) )
      = ( P = Q ) ) ).

% poly_eq_poly_eq_iff
thf(fact_43_poly__eq__poly__eq__iff,axiom,
    ! [P: poly_poly_real,Q: poly_poly_real] :
      ( ( ( poly_poly_real2 @ P )
        = ( poly_poly_real2 @ Q ) )
      = ( P = Q ) ) ).

% poly_eq_poly_eq_iff
thf(fact_44_cross__0,axiom,
    ! [A: real,B: real] :
      ( ( sturm_1953858694_cross @ zero_zero_poly_real @ A @ B )
      = zero_zero_int ) ).

% cross_0
thf(fact_45_rsquarefree__roots,axiom,
    ( rsquarefree_real
    = ( ^ [P2: poly_real] :
        ! [A2: real] :
          ~ ( ( ( poly_real2 @ P2 @ A2 )
              = zero_zero_real )
            & ( ( poly_real2 @ ( pderiv_real @ P2 ) @ A2 )
              = zero_zero_real ) ) ) ) ).

% rsquarefree_roots
thf(fact_46_cross__no__root,axiom,
    ! [A: real,B: real,P: poly_real] :
      ( ( ord_less_real @ A @ B )
     => ( ! [X2: real] :
            ( ( ( ord_less_real @ A @ X2 )
              & ( ord_less_real @ X2 @ B ) )
           => ( ( poly_real2 @ P @ X2 )
             != zero_zero_real ) )
       => ( ( sturm_1953858694_cross @ P @ A @ B )
          = zero_zero_int ) ) ) ).

% cross_no_root
thf(fact_47_is__zero__null,axiom,
    ( is_zero_real
    = ( ^ [P2: poly_real] : ( P2 = zero_zero_poly_real ) ) ) ).

% is_zero_null
thf(fact_48_is__zero__null,axiom,
    ( is_zero_nat
    = ( ^ [P2: poly_nat] : ( P2 = zero_zero_poly_nat ) ) ) ).

% is_zero_null
thf(fact_49_is__zero__null,axiom,
    ( is_zero_int
    = ( ^ [P2: poly_int] : ( P2 = zero_zero_poly_int ) ) ) ).

% is_zero_null
thf(fact_50_is__zero__null,axiom,
    ( is_zero_poly_real
    = ( ^ [P2: poly_poly_real] : ( P2 = zero_z1423781445y_real ) ) ) ).

% is_zero_null
thf(fact_51_poly__cutoff__0,axiom,
    ! [N: nat] :
      ( ( poly_cutoff_real @ N @ zero_zero_poly_real )
      = zero_zero_poly_real ) ).

% poly_cutoff_0
thf(fact_52_poly__cutoff__0,axiom,
    ! [N: nat] :
      ( ( poly_cutoff_nat @ N @ zero_zero_poly_nat )
      = zero_zero_poly_nat ) ).

% poly_cutoff_0
thf(fact_53_poly__cutoff__0,axiom,
    ! [N: nat] :
      ( ( poly_cutoff_int @ N @ zero_zero_poly_int )
      = zero_zero_poly_int ) ).

% poly_cutoff_0
thf(fact_54_poly__cutoff__0,axiom,
    ! [N: nat] :
      ( ( poly_c1404107022y_real @ N @ zero_z1423781445y_real )
      = zero_z1423781445y_real ) ).

% poly_cutoff_0
thf(fact_55_reflect__poly__at__0__eq__0__iff,axiom,
    ! [P: poly_real] :
      ( ( ( poly_real2 @ ( reflect_poly_real @ P ) @ zero_zero_real )
        = zero_zero_real )
      = ( P = zero_zero_poly_real ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_56_reflect__poly__at__0__eq__0__iff,axiom,
    ! [P: poly_poly_real] :
      ( ( ( poly_poly_real2 @ ( reflec1522834046y_real @ P ) @ zero_zero_poly_real )
        = zero_zero_poly_real )
      = ( P = zero_z1423781445y_real ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_57_reflect__poly__at__0__eq__0__iff,axiom,
    ! [P: poly_int] :
      ( ( ( poly_int2 @ ( reflect_poly_int @ P ) @ zero_zero_int )
        = zero_zero_int )
      = ( P = zero_zero_poly_int ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_58_reflect__poly__at__0__eq__0__iff,axiom,
    ! [P: poly_nat] :
      ( ( ( poly_nat2 @ ( reflect_poly_nat @ P ) @ zero_zero_nat )
        = zero_zero_nat )
      = ( P = zero_zero_poly_nat ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_59_reflect__poly__at__0__eq__0__iff,axiom,
    ! [P: poly_poly_nat] :
      ( ( ( poly_poly_nat2 @ ( reflec781175074ly_nat @ P ) @ zero_zero_poly_nat )
        = zero_zero_poly_nat )
      = ( P = zero_z1059985641ly_nat ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_60_reflect__poly__at__0__eq__0__iff,axiom,
    ! [P: poly_poly_int] :
      ( ( ( poly_poly_int2 @ ( reflec943087998ly_int @ P ) @ zero_zero_poly_int )
        = zero_zero_poly_int )
      = ( P = zero_z1549157189ly_int ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_61_reflect__poly__at__0__eq__0__iff,axiom,
    ! [P: poly_poly_poly_real] :
      ( ( ( poly_poly_poly_real2 @ ( reflec144234502y_real @ P ) @ zero_z1423781445y_real )
        = zero_z1423781445y_real )
      = ( P = zero_z935034829y_real ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_62_next__non__root__interval,axiom,
    ! [P: poly_real,Lb: real] :
      ( ( P != zero_zero_poly_real )
     => ~ ! [Ub: real] :
            ( ( ord_less_real @ Lb @ Ub )
           => ~ ! [Z: real] :
                  ( ( ( ord_less_real @ Lb @ Z )
                    & ( ord_less_eq_real @ Z @ Ub ) )
                 => ( ( poly_real2 @ P @ Z )
                   != zero_zero_real ) ) ) ) ).

% next_non_root_interval
thf(fact_63_last__non__root__interval,axiom,
    ! [P: poly_real,Ub2: real] :
      ( ( P != zero_zero_poly_real )
     => ~ ! [Lb2: real] :
            ( ( ord_less_real @ Lb2 @ Ub2 )
           => ~ ! [Z: real] :
                  ( ( ( ord_less_eq_real @ Lb2 @ Z )
                    & ( ord_less_real @ Z @ Ub2 ) )
                 => ( ( poly_real2 @ P @ Z )
                   != zero_zero_real ) ) ) ) ).

% last_non_root_interval
thf(fact_64_poly__shift__0,axiom,
    ! [N: nat] :
      ( ( poly_shift_real @ N @ zero_zero_poly_real )
      = zero_zero_poly_real ) ).

% poly_shift_0
thf(fact_65_poly__shift__0,axiom,
    ! [N: nat] :
      ( ( poly_shift_nat @ N @ zero_zero_poly_nat )
      = zero_zero_poly_nat ) ).

% poly_shift_0
thf(fact_66_poly__shift__0,axiom,
    ! [N: nat] :
      ( ( poly_shift_int @ N @ zero_zero_poly_int )
      = zero_zero_poly_int ) ).

% poly_shift_0
thf(fact_67_poly__shift__0,axiom,
    ! [N: nat] :
      ( ( poly_shift_poly_real @ N @ zero_z1423781445y_real )
      = zero_z1423781445y_real ) ).

% poly_shift_0
thf(fact_68_order__root,axiom,
    ! [P: poly_real,A: real] :
      ( ( ( poly_real2 @ P @ A )
        = zero_zero_real )
      = ( ( P = zero_zero_poly_real )
        | ( ( order_real @ A @ P )
         != zero_zero_nat ) ) ) ).

% order_root
thf(fact_69_order__root,axiom,
    ! [P: poly_poly_real,A: poly_real] :
      ( ( ( poly_poly_real2 @ P @ A )
        = zero_zero_poly_real )
      = ( ( P = zero_z1423781445y_real )
        | ( ( order_poly_real @ A @ P )
         != zero_zero_nat ) ) ) ).

% order_root
thf(fact_70_order__root,axiom,
    ! [P: poly_int,A: int] :
      ( ( ( poly_int2 @ P @ A )
        = zero_zero_int )
      = ( ( P = zero_zero_poly_int )
        | ( ( order_int @ A @ P )
         != zero_zero_nat ) ) ) ).

% order_root
thf(fact_71_order__root,axiom,
    ! [P: poly_poly_int,A: poly_int] :
      ( ( ( poly_poly_int2 @ P @ A )
        = zero_zero_poly_int )
      = ( ( P = zero_z1549157189ly_int )
        | ( ( order_poly_int @ A @ P )
         != zero_zero_nat ) ) ) ).

% order_root
thf(fact_72_order__root,axiom,
    ! [P: poly_poly_poly_real,A: poly_poly_real] :
      ( ( ( poly_poly_poly_real2 @ P @ A )
        = zero_z1423781445y_real )
      = ( ( P = zero_z935034829y_real )
        | ( ( order_poly_poly_real @ A @ P )
         != zero_zero_nat ) ) ) ).

% order_root
thf(fact_73_le__zero__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
      = ( N = zero_zero_nat ) ) ).

% le_zero_eq
thf(fact_74_reflect__poly__0,axiom,
    ( ( reflect_poly_real @ zero_zero_poly_real )
    = zero_zero_poly_real ) ).

% reflect_poly_0
thf(fact_75_reflect__poly__0,axiom,
    ( ( reflect_poly_nat @ zero_zero_poly_nat )
    = zero_zero_poly_nat ) ).

% reflect_poly_0
thf(fact_76_reflect__poly__0,axiom,
    ( ( reflect_poly_int @ zero_zero_poly_int )
    = zero_zero_poly_int ) ).

% reflect_poly_0
thf(fact_77_reflect__poly__0,axiom,
    ( ( reflec1522834046y_real @ zero_z1423781445y_real )
    = zero_z1423781445y_real ) ).

% reflect_poly_0
thf(fact_78_complete__real,axiom,
    ! [S: set_real] :
      ( ? [X4: real] : ( member_real @ X4 @ S )
     => ( ? [Z: real] :
          ! [X2: real] :
            ( ( member_real @ X2 @ S )
           => ( ord_less_eq_real @ X2 @ Z ) )
       => ? [Y: real] :
            ( ! [X4: real] :
                ( ( member_real @ X4 @ S )
               => ( ord_less_eq_real @ X4 @ Y ) )
            & ! [Z: real] :
                ( ! [X2: real] :
                    ( ( member_real @ X2 @ S )
                   => ( ord_less_eq_real @ X2 @ Z ) )
               => ( ord_less_eq_real @ Y @ Z ) ) ) ) ) ).

% complete_real
thf(fact_79_le__numeral__extra_I3_J,axiom,
    ord_le1180086932y_real @ zero_zero_poly_real @ zero_zero_poly_real ).

% le_numeral_extra(3)
thf(fact_80_le__numeral__extra_I3_J,axiom,
    ord_less_eq_poly_int @ zero_zero_poly_int @ zero_zero_poly_int ).

% le_numeral_extra(3)
thf(fact_81_le__numeral__extra_I3_J,axiom,
    ord_le893774876y_real @ zero_z1423781445y_real @ zero_z1423781445y_real ).

% le_numeral_extra(3)
thf(fact_82_le__numeral__extra_I3_J,axiom,
    ord_less_eq_real @ zero_zero_real @ zero_zero_real ).

% le_numeral_extra(3)
thf(fact_83_le__numeral__extra_I3_J,axiom,
    ord_less_eq_nat @ zero_zero_nat @ zero_zero_nat ).

% le_numeral_extra(3)
thf(fact_84_le__numeral__extra_I3_J,axiom,
    ord_less_eq_int @ zero_zero_int @ zero_zero_int ).

% le_numeral_extra(3)
thf(fact_85_zero__le,axiom,
    ! [X: nat] : ( ord_less_eq_nat @ zero_zero_nat @ X ) ).

% zero_le
thf(fact_86_less__eq__real__def,axiom,
    ( ord_less_eq_real
    = ( ^ [X3: real,Y2: real] :
          ( ( ord_less_real @ X3 @ Y2 )
          | ( X3 = Y2 ) ) ) ) ).

% less_eq_real_def
thf(fact_87_order__0I,axiom,
    ! [P: poly_real,A: real] :
      ( ( ( poly_real2 @ P @ A )
       != zero_zero_real )
     => ( ( order_real @ A @ P )
        = zero_zero_nat ) ) ).

% order_0I
thf(fact_88_order__0I,axiom,
    ! [P: poly_poly_real,A: poly_real] :
      ( ( ( poly_poly_real2 @ P @ A )
       != zero_zero_poly_real )
     => ( ( order_poly_real @ A @ P )
        = zero_zero_nat ) ) ).

% order_0I
thf(fact_89_order__0I,axiom,
    ! [P: poly_int,A: int] :
      ( ( ( poly_int2 @ P @ A )
       != zero_zero_int )
     => ( ( order_int @ A @ P )
        = zero_zero_nat ) ) ).

% order_0I
thf(fact_90_order__0I,axiom,
    ! [P: poly_poly_int,A: poly_int] :
      ( ( ( poly_poly_int2 @ P @ A )
       != zero_zero_poly_int )
     => ( ( order_poly_int @ A @ P )
        = zero_zero_nat ) ) ).

% order_0I
thf(fact_91_order__0I,axiom,
    ! [P: poly_poly_poly_real,A: poly_poly_real] :
      ( ( ( poly_poly_poly_real2 @ P @ A )
       != zero_z1423781445y_real )
     => ( ( order_poly_poly_real @ A @ P )
        = zero_zero_nat ) ) ).

% order_0I
thf(fact_92_not__eq__pos__or__neg__iff__1,axiom,
    ! [Lb: real,Ub2: real,P: poly_real] :
      ( ( ! [Z2: real] :
            ( ( ( ord_less_real @ Lb @ Z2 )
              & ( ord_less_eq_real @ Z2 @ Ub2 ) )
           => ( ( poly_real2 @ P @ Z2 )
             != zero_zero_real ) ) )
      = ( ! [Z2: real] :
            ( ( ( ord_less_real @ Lb @ Z2 )
              & ( ord_less_eq_real @ Z2 @ Ub2 ) )
           => ( ord_less_real @ zero_zero_real @ ( poly_real2 @ P @ Z2 ) ) )
        | ! [Z2: real] :
            ( ( ( ord_less_real @ Lb @ Z2 )
              & ( ord_less_eq_real @ Z2 @ Ub2 ) )
           => ( ord_less_real @ ( poly_real2 @ P @ Z2 ) @ zero_zero_real ) ) ) ) ).

% not_eq_pos_or_neg_iff_1
thf(fact_93_not__eq__pos__or__neg__iff__2,axiom,
    ! [Lb: real,Ub2: real,P: poly_real] :
      ( ( ! [Z2: real] :
            ( ( ( ord_less_eq_real @ Lb @ Z2 )
              & ( ord_less_real @ Z2 @ Ub2 ) )
           => ( ( poly_real2 @ P @ Z2 )
             != zero_zero_real ) ) )
      = ( ! [Z2: real] :
            ( ( ( ord_less_eq_real @ Lb @ Z2 )
              & ( ord_less_real @ Z2 @ Ub2 ) )
           => ( ord_less_real @ zero_zero_real @ ( poly_real2 @ P @ Z2 ) ) )
        | ! [Z2: real] :
            ( ( ( ord_less_eq_real @ Lb @ Z2 )
              & ( ord_less_real @ Z2 @ Ub2 ) )
           => ( ord_less_real @ ( poly_real2 @ P @ Z2 ) @ zero_zero_real ) ) ) ) ).

% not_eq_pos_or_neg_iff_2
thf(fact_94_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
      = ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% neq0_conv
thf(fact_95_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% less_nat_zero_code
thf(fact_96_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A: nat] :
      ( ( A != zero_zero_nat )
      = ( ord_less_nat @ zero_zero_nat @ A ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_97_order__refl,axiom,
    ! [X: real] : ( ord_less_eq_real @ X @ X ) ).

% order_refl
thf(fact_98_order__refl,axiom,
    ! [X: nat] : ( ord_less_eq_nat @ X @ X ) ).

% order_refl
thf(fact_99_order__refl,axiom,
    ! [X: int] : ( ord_less_eq_int @ X @ X ) ).

% order_refl
thf(fact_100_minf_I8_J,axiom,
    ! [T: real] :
    ? [Z3: real] :
    ! [X4: real] :
      ( ( ord_less_real @ X4 @ Z3 )
     => ~ ( ord_less_eq_real @ T @ X4 ) ) ).

% minf(8)
thf(fact_101_minf_I8_J,axiom,
    ! [T: nat] :
    ? [Z3: nat] :
    ! [X4: nat] :
      ( ( ord_less_nat @ X4 @ Z3 )
     => ~ ( ord_less_eq_nat @ T @ X4 ) ) ).

% minf(8)
thf(fact_102_minf_I8_J,axiom,
    ! [T: int] :
    ? [Z3: int] :
    ! [X4: int] :
      ( ( ord_less_int @ X4 @ Z3 )
     => ~ ( ord_less_eq_int @ T @ X4 ) ) ).

% minf(8)
thf(fact_103_minf_I6_J,axiom,
    ! [T: real] :
    ? [Z3: real] :
    ! [X4: real] :
      ( ( ord_less_real @ X4 @ Z3 )
     => ( ord_less_eq_real @ X4 @ T ) ) ).

% minf(6)
thf(fact_104_minf_I6_J,axiom,
    ! [T: nat] :
    ? [Z3: nat] :
    ! [X4: nat] :
      ( ( ord_less_nat @ X4 @ Z3 )
     => ( ord_less_eq_nat @ X4 @ T ) ) ).

% minf(6)
thf(fact_105_minf_I6_J,axiom,
    ! [T: int] :
    ? [Z3: int] :
    ! [X4: int] :
      ( ( ord_less_int @ X4 @ Z3 )
     => ( ord_less_eq_int @ X4 @ T ) ) ).

% minf(6)
thf(fact_106_mem__Collect__eq,axiom,
    ! [A: real,P3: real > $o] :
      ( ( member_real @ A @ ( collect_real @ P3 ) )
      = ( P3 @ A ) ) ).

% mem_Collect_eq
thf(fact_107_Collect__mem__eq,axiom,
    ! [A3: set_real] :
      ( ( collect_real
        @ ^ [X3: real] : ( member_real @ X3 @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_108_pinf_I8_J,axiom,
    ! [T: real] :
    ? [Z3: real] :
    ! [X4: real] :
      ( ( ord_less_real @ Z3 @ X4 )
     => ( ord_less_eq_real @ T @ X4 ) ) ).

% pinf(8)
thf(fact_109_pinf_I8_J,axiom,
    ! [T: nat] :
    ? [Z3: nat] :
    ! [X4: nat] :
      ( ( ord_less_nat @ Z3 @ X4 )
     => ( ord_less_eq_nat @ T @ X4 ) ) ).

% pinf(8)
thf(fact_110_pinf_I8_J,axiom,
    ! [T: int] :
    ? [Z3: int] :
    ! [X4: int] :
      ( ( ord_less_int @ Z3 @ X4 )
     => ( ord_less_eq_int @ T @ X4 ) ) ).

% pinf(8)
thf(fact_111_pinf_I6_J,axiom,
    ! [T: real] :
    ? [Z3: real] :
    ! [X4: real] :
      ( ( ord_less_real @ Z3 @ X4 )
     => ~ ( ord_less_eq_real @ X4 @ T ) ) ).

% pinf(6)
thf(fact_112_pinf_I6_J,axiom,
    ! [T: nat] :
    ? [Z3: nat] :
    ! [X4: nat] :
      ( ( ord_less_nat @ Z3 @ X4 )
     => ~ ( ord_less_eq_nat @ X4 @ T ) ) ).

% pinf(6)
thf(fact_113_pinf_I6_J,axiom,
    ! [T: int] :
    ? [Z3: int] :
    ! [X4: int] :
      ( ( ord_less_int @ Z3 @ X4 )
     => ~ ( ord_less_eq_int @ X4 @ T ) ) ).

% pinf(6)
thf(fact_114_verit__comp__simplify1_I3_J,axiom,
    ! [B2: real,A4: real] :
      ( ( ~ ( ord_less_eq_real @ B2 @ A4 ) )
      = ( ord_less_real @ A4 @ B2 ) ) ).

% verit_comp_simplify1(3)
thf(fact_115_verit__comp__simplify1_I3_J,axiom,
    ! [B2: nat,A4: nat] :
      ( ( ~ ( ord_less_eq_nat @ B2 @ A4 ) )
      = ( ord_less_nat @ A4 @ B2 ) ) ).

% verit_comp_simplify1(3)
thf(fact_116_verit__comp__simplify1_I3_J,axiom,
    ! [B2: int,A4: int] :
      ( ( ~ ( ord_less_eq_int @ B2 @ A4 ) )
      = ( ord_less_int @ A4 @ B2 ) ) ).

% verit_comp_simplify1(3)
thf(fact_117_bot__nat__0_Oextremum,axiom,
    ! [A: nat] : ( ord_less_eq_nat @ zero_zero_nat @ A ) ).

% bot_nat_0.extremum
thf(fact_118_le0,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ zero_zero_nat @ N ) ).

% le0
thf(fact_119_nat__less__le,axiom,
    ( ord_less_nat
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less_eq_nat @ M2 @ N2 )
          & ( M2 != N2 ) ) ) ) ).

% nat_less_le
thf(fact_120_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_121_le__eq__less__or__eq,axiom,
    ( ord_less_eq_nat
    = ( ^ [M2: nat,N2: nat] :
          ( ( ord_less_nat @ M2 @ N2 )
          | ( M2 = N2 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_122_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less_nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_123_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( M != N )
       => ( ord_less_nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_124_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I: nat,J: nat] :
      ( ! [I2: nat,J2: nat] :
          ( ( ord_less_nat @ I2 @ J2 )
         => ( ord_less_nat @ ( F @ I2 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq_nat @ I @ J )
       => ( ord_less_eq_nat @ ( F @ I ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_125_linorder__neqE__nat,axiom,
    ! [X: nat,Y3: nat] :
      ( ( X != Y3 )
     => ( ~ ( ord_less_nat @ X @ Y3 )
       => ( ord_less_nat @ Y3 @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_126_infinite__descent,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ~ ( P3 @ N3 )
         => ? [M3: nat] :
              ( ( ord_less_nat @ M3 @ N3 )
              & ~ ( P3 @ M3 ) ) )
     => ( P3 @ N ) ) ).

% infinite_descent
thf(fact_127_nat__less__induct,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M3: nat] :
              ( ( ord_less_nat @ M3 @ N3 )
             => ( P3 @ M3 ) )
         => ( P3 @ N3 ) )
     => ( P3 @ N ) ) ).

% nat_less_induct
thf(fact_128_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_129_less__not__refl3,axiom,
    ! [S2: nat,T: nat] :
      ( ( ord_less_nat @ S2 @ T )
     => ( S2 != T ) ) ).

% less_not_refl3
thf(fact_130_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_131_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_not_refl
thf(fact_132_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less_nat @ M @ N )
        | ( ord_less_nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_133_bot__nat__0_Oextremum__uniqueI,axiom,
    ! [A: nat] :
      ( ( ord_less_eq_nat @ A @ zero_zero_nat )
     => ( A = zero_zero_nat ) ) ).

% bot_nat_0.extremum_uniqueI
thf(fact_134_bot__nat__0_Oextremum__unique,axiom,
    ! [A: nat] :
      ( ( ord_less_eq_nat @ A @ zero_zero_nat )
      = ( A = zero_zero_nat ) ) ).

% bot_nat_0.extremum_unique
thf(fact_135_ex__least__nat__le,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ( P3 @ N )
     => ( ~ ( P3 @ zero_zero_nat )
       => ? [K: nat] :
            ( ( ord_less_eq_nat @ K @ N )
            & ! [I3: nat] :
                ( ( ord_less_nat @ I3 @ K )
               => ~ ( P3 @ I3 ) )
            & ( P3 @ K ) ) ) ) ).

% ex_least_nat_le
thf(fact_136_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
      = ( N = zero_zero_nat ) ) ).

% le_0_eq
thf(fact_137_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ zero_zero_nat @ N ) ).

% less_eq_nat.simps(1)
thf(fact_138_conj__le__cong,axiom,
    ! [X: int,X5: int,P3: $o,P4: $o] :
      ( ( X = X5 )
     => ( ( ( ord_less_eq_int @ zero_zero_int @ X5 )
         => ( P3 = P4 ) )
       => ( ( ( ord_less_eq_int @ zero_zero_int @ X )
            & P3 )
          = ( ( ord_less_eq_int @ zero_zero_int @ X5 )
            & P4 ) ) ) ) ).

% conj_le_cong
thf(fact_139_imp__le__cong,axiom,
    ! [X: int,X5: int,P3: $o,P4: $o] :
      ( ( X = X5 )
     => ( ( ( ord_less_eq_int @ zero_zero_int @ X5 )
         => ( P3 = P4 ) )
       => ( ( ( ord_less_eq_int @ zero_zero_int @ X )
           => P3 )
          = ( ( ord_less_eq_int @ zero_zero_int @ X5 )
           => P4 ) ) ) ) ).

% imp_le_cong
thf(fact_140_order__subst1,axiom,
    ! [A: real,F: real > real,B: real,C: real] :
      ( ( ord_less_eq_real @ A @ ( F @ B ) )
     => ( ( ord_less_eq_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_141_order__subst1,axiom,
    ! [A: real,F: nat > real,B: nat,C: nat] :
      ( ( ord_less_eq_real @ A @ ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_142_order__subst1,axiom,
    ! [A: real,F: int > real,B: int,C: int] :
      ( ( ord_less_eq_real @ A @ ( F @ B ) )
     => ( ( ord_less_eq_int @ B @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_143_order__subst1,axiom,
    ! [A: nat,F: real > nat,B: real,C: real] :
      ( ( ord_less_eq_nat @ A @ ( F @ B ) )
     => ( ( ord_less_eq_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_144_order__subst1,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_145_order__subst1,axiom,
    ! [A: nat,F: int > nat,B: int,C: int] :
      ( ( ord_less_eq_nat @ A @ ( F @ B ) )
     => ( ( ord_less_eq_int @ B @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_146_order__subst1,axiom,
    ! [A: int,F: real > int,B: real,C: real] :
      ( ( ord_less_eq_int @ A @ ( F @ B ) )
     => ( ( ord_less_eq_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_147_order__subst1,axiom,
    ! [A: int,F: nat > int,B: nat,C: nat] :
      ( ( ord_less_eq_int @ A @ ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_148_order__subst1,axiom,
    ! [A: int,F: int > int,B: int,C: int] :
      ( ( ord_less_eq_int @ A @ ( F @ B ) )
     => ( ( ord_less_eq_int @ B @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_149_order__subst2,axiom,
    ! [A: real,B: real,F: real > real,C: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ord_less_eq_real @ ( F @ B ) @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_150_order__subst2,axiom,
    ! [A: real,B: real,F: real > nat,C: nat] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ord_less_eq_nat @ ( F @ B ) @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_151_order__subst2,axiom,
    ! [A: real,B: real,F: real > int,C: int] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ord_less_eq_int @ ( F @ B ) @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_152_order__subst2,axiom,
    ! [A: nat,B: nat,F: nat > real,C: real] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_real @ ( F @ B ) @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_153_order__subst2,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ ( F @ B ) @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_154_order__subst2,axiom,
    ! [A: nat,B: nat,F: nat > int,C: int] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_int @ ( F @ B ) @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_155_order__subst2,axiom,
    ! [A: int,B: int,F: int > real,C: real] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( ord_less_eq_real @ ( F @ B ) @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_156_order__subst2,axiom,
    ! [A: int,B: int,F: int > nat,C: nat] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( ord_less_eq_nat @ ( F @ B ) @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_157_order__subst2,axiom,
    ! [A: int,B: int,F: int > int,C: int] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( ord_less_eq_int @ ( F @ B ) @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_158_verit__la__disequality,axiom,
    ! [A: real,B: real] :
      ( ( A = B )
      | ~ ( ord_less_eq_real @ A @ B )
      | ~ ( ord_less_eq_real @ B @ A ) ) ).

% verit_la_disequality
thf(fact_159_verit__la__disequality,axiom,
    ! [A: nat,B: nat] :
      ( ( A = B )
      | ~ ( ord_less_eq_nat @ A @ B )
      | ~ ( ord_less_eq_nat @ B @ A ) ) ).

% verit_la_disequality
thf(fact_160_verit__la__disequality,axiom,
    ! [A: int,B: int] :
      ( ( A = B )
      | ~ ( ord_less_eq_int @ A @ B )
      | ~ ( ord_less_eq_int @ B @ A ) ) ).

% verit_la_disequality
thf(fact_161_ord__eq__le__subst,axiom,
    ! [A: real,F: real > real,B: real,C: real] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_162_ord__eq__le__subst,axiom,
    ! [A: nat,F: real > nat,B: real,C: real] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_163_ord__eq__le__subst,axiom,
    ! [A: int,F: real > int,B: real,C: real] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_164_ord__eq__le__subst,axiom,
    ! [A: real,F: nat > real,B: nat,C: nat] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_165_ord__eq__le__subst,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_166_ord__eq__le__subst,axiom,
    ! [A: int,F: nat > int,B: nat,C: nat] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_167_ord__eq__le__subst,axiom,
    ! [A: real,F: int > real,B: int,C: int] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_int @ B @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_168_ord__eq__le__subst,axiom,
    ! [A: nat,F: int > nat,B: int,C: int] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_int @ B @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_169_ord__eq__le__subst,axiom,
    ! [A: int,F: int > int,B: int,C: int] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_int @ B @ C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_170_ord__le__eq__subst,axiom,
    ! [A: real,B: real,F: real > real,C: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_171_ord__le__eq__subst,axiom,
    ! [A: real,B: real,F: real > nat,C: nat] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_172_ord__le__eq__subst,axiom,
    ! [A: real,B: real,F: real > int,C: int] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_eq_real @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_173_ord__le__eq__subst,axiom,
    ! [A: nat,B: nat,F: nat > real,C: real] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_174_ord__le__eq__subst,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_175_ord__le__eq__subst,axiom,
    ! [A: nat,B: nat,F: nat > int,C: int] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_eq_nat @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_176_ord__le__eq__subst,axiom,
    ! [A: int,B: int,F: int > real,C: real] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_real @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_177_ord__le__eq__subst,axiom,
    ! [A: int,B: int,F: int > nat,C: nat] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_nat @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_178_ord__le__eq__subst,axiom,
    ! [A: int,B: int,F: int > int,C: int] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: int,Y: int] :
              ( ( ord_less_eq_int @ X2 @ Y )
             => ( ord_less_eq_int @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_eq_int @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_179_eq__iff,axiom,
    ( ( ^ [Y4: real,Z4: real] : ( Y4 = Z4 ) )
    = ( ^ [X3: real,Y2: real] :
          ( ( ord_less_eq_real @ X3 @ Y2 )
          & ( ord_less_eq_real @ Y2 @ X3 ) ) ) ) ).

% eq_iff
thf(fact_180_eq__iff,axiom,
    ( ( ^ [Y4: nat,Z4: nat] : ( Y4 = Z4 ) )
    = ( ^ [X3: nat,Y2: nat] :
          ( ( ord_less_eq_nat @ X3 @ Y2 )
          & ( ord_less_eq_nat @ Y2 @ X3 ) ) ) ) ).

% eq_iff
thf(fact_181_eq__iff,axiom,
    ( ( ^ [Y4: int,Z4: int] : ( Y4 = Z4 ) )
    = ( ^ [X3: int,Y2: int] :
          ( ( ord_less_eq_int @ X3 @ Y2 )
          & ( ord_less_eq_int @ Y2 @ X3 ) ) ) ) ).

% eq_iff
thf(fact_182_antisym,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_eq_real @ X @ Y3 )
     => ( ( ord_less_eq_real @ Y3 @ X )
       => ( X = Y3 ) ) ) ).

% antisym
thf(fact_183_antisym,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_eq_nat @ X @ Y3 )
     => ( ( ord_less_eq_nat @ Y3 @ X )
       => ( X = Y3 ) ) ) ).

% antisym
thf(fact_184_antisym,axiom,
    ! [X: int,Y3: int] :
      ( ( ord_less_eq_int @ X @ Y3 )
     => ( ( ord_less_eq_int @ Y3 @ X )
       => ( X = Y3 ) ) ) ).

% antisym
thf(fact_185_linear,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_eq_real @ X @ Y3 )
      | ( ord_less_eq_real @ Y3 @ X ) ) ).

% linear
thf(fact_186_linear,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_eq_nat @ X @ Y3 )
      | ( ord_less_eq_nat @ Y3 @ X ) ) ).

% linear
thf(fact_187_linear,axiom,
    ! [X: int,Y3: int] :
      ( ( ord_less_eq_int @ X @ Y3 )
      | ( ord_less_eq_int @ Y3 @ X ) ) ).

% linear
thf(fact_188_eq__refl,axiom,
    ! [X: real,Y3: real] :
      ( ( X = Y3 )
     => ( ord_less_eq_real @ X @ Y3 ) ) ).

% eq_refl
thf(fact_189_eq__refl,axiom,
    ! [X: nat,Y3: nat] :
      ( ( X = Y3 )
     => ( ord_less_eq_nat @ X @ Y3 ) ) ).

% eq_refl
thf(fact_190_eq__refl,axiom,
    ! [X: int,Y3: int] :
      ( ( X = Y3 )
     => ( ord_less_eq_int @ X @ Y3 ) ) ).

% eq_refl
thf(fact_191_le__cases,axiom,
    ! [X: real,Y3: real] :
      ( ~ ( ord_less_eq_real @ X @ Y3 )
     => ( ord_less_eq_real @ Y3 @ X ) ) ).

% le_cases
thf(fact_192_le__cases,axiom,
    ! [X: nat,Y3: nat] :
      ( ~ ( ord_less_eq_nat @ X @ Y3 )
     => ( ord_less_eq_nat @ Y3 @ X ) ) ).

% le_cases
thf(fact_193_le__cases,axiom,
    ! [X: int,Y3: int] :
      ( ~ ( ord_less_eq_int @ X @ Y3 )
     => ( ord_less_eq_int @ Y3 @ X ) ) ).

% le_cases
thf(fact_194_order_Otrans,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ord_less_eq_real @ B @ C )
       => ( ord_less_eq_real @ A @ C ) ) ) ).

% order.trans
thf(fact_195_order_Otrans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ord_less_eq_nat @ A @ C ) ) ) ).

% order.trans
thf(fact_196_order_Otrans,axiom,
    ! [A: int,B: int,C: int] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( ord_less_eq_int @ B @ C )
       => ( ord_less_eq_int @ A @ C ) ) ) ).

% order.trans
thf(fact_197_le__cases3,axiom,
    ! [X: real,Y3: real,Z5: real] :
      ( ( ( ord_less_eq_real @ X @ Y3 )
       => ~ ( ord_less_eq_real @ Y3 @ Z5 ) )
     => ( ( ( ord_less_eq_real @ Y3 @ X )
         => ~ ( ord_less_eq_real @ X @ Z5 ) )
       => ( ( ( ord_less_eq_real @ X @ Z5 )
           => ~ ( ord_less_eq_real @ Z5 @ Y3 ) )
         => ( ( ( ord_less_eq_real @ Z5 @ Y3 )
             => ~ ( ord_less_eq_real @ Y3 @ X ) )
           => ( ( ( ord_less_eq_real @ Y3 @ Z5 )
               => ~ ( ord_less_eq_real @ Z5 @ X ) )
             => ~ ( ( ord_less_eq_real @ Z5 @ X )
                 => ~ ( ord_less_eq_real @ X @ Y3 ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_198_le__cases3,axiom,
    ! [X: nat,Y3: nat,Z5: nat] :
      ( ( ( ord_less_eq_nat @ X @ Y3 )
       => ~ ( ord_less_eq_nat @ Y3 @ Z5 ) )
     => ( ( ( ord_less_eq_nat @ Y3 @ X )
         => ~ ( ord_less_eq_nat @ X @ Z5 ) )
       => ( ( ( ord_less_eq_nat @ X @ Z5 )
           => ~ ( ord_less_eq_nat @ Z5 @ Y3 ) )
         => ( ( ( ord_less_eq_nat @ Z5 @ Y3 )
             => ~ ( ord_less_eq_nat @ Y3 @ X ) )
           => ( ( ( ord_less_eq_nat @ Y3 @ Z5 )
               => ~ ( ord_less_eq_nat @ Z5 @ X ) )
             => ~ ( ( ord_less_eq_nat @ Z5 @ X )
                 => ~ ( ord_less_eq_nat @ X @ Y3 ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_199_le__cases3,axiom,
    ! [X: int,Y3: int,Z5: int] :
      ( ( ( ord_less_eq_int @ X @ Y3 )
       => ~ ( ord_less_eq_int @ Y3 @ Z5 ) )
     => ( ( ( ord_less_eq_int @ Y3 @ X )
         => ~ ( ord_less_eq_int @ X @ Z5 ) )
       => ( ( ( ord_less_eq_int @ X @ Z5 )
           => ~ ( ord_less_eq_int @ Z5 @ Y3 ) )
         => ( ( ( ord_less_eq_int @ Z5 @ Y3 )
             => ~ ( ord_less_eq_int @ Y3 @ X ) )
           => ( ( ( ord_less_eq_int @ Y3 @ Z5 )
               => ~ ( ord_less_eq_int @ Z5 @ X ) )
             => ~ ( ( ord_less_eq_int @ Z5 @ X )
                 => ~ ( ord_less_eq_int @ X @ Y3 ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_200_antisym__conv,axiom,
    ! [Y3: real,X: real] :
      ( ( ord_less_eq_real @ Y3 @ X )
     => ( ( ord_less_eq_real @ X @ Y3 )
        = ( X = Y3 ) ) ) ).

% antisym_conv
thf(fact_201_antisym__conv,axiom,
    ! [Y3: nat,X: nat] :
      ( ( ord_less_eq_nat @ Y3 @ X )
     => ( ( ord_less_eq_nat @ X @ Y3 )
        = ( X = Y3 ) ) ) ).

% antisym_conv
thf(fact_202_antisym__conv,axiom,
    ! [Y3: int,X: int] :
      ( ( ord_less_eq_int @ Y3 @ X )
     => ( ( ord_less_eq_int @ X @ Y3 )
        = ( X = Y3 ) ) ) ).

% antisym_conv
thf(fact_203_order__class_Oorder_Oeq__iff,axiom,
    ( ( ^ [Y4: real,Z4: real] : ( Y4 = Z4 ) )
    = ( ^ [A2: real,B3: real] :
          ( ( ord_less_eq_real @ A2 @ B3 )
          & ( ord_less_eq_real @ B3 @ A2 ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_204_order__class_Oorder_Oeq__iff,axiom,
    ( ( ^ [Y4: nat,Z4: nat] : ( Y4 = Z4 ) )
    = ( ^ [A2: nat,B3: nat] :
          ( ( ord_less_eq_nat @ A2 @ B3 )
          & ( ord_less_eq_nat @ B3 @ A2 ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_205_order__class_Oorder_Oeq__iff,axiom,
    ( ( ^ [Y4: int,Z4: int] : ( Y4 = Z4 ) )
    = ( ^ [A2: int,B3: int] :
          ( ( ord_less_eq_int @ A2 @ B3 )
          & ( ord_less_eq_int @ B3 @ A2 ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_206_ord__eq__le__trans,axiom,
    ! [A: real,B: real,C: real] :
      ( ( A = B )
     => ( ( ord_less_eq_real @ B @ C )
       => ( ord_less_eq_real @ A @ C ) ) ) ).

% ord_eq_le_trans
thf(fact_207_ord__eq__le__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( A = B )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ord_less_eq_nat @ A @ C ) ) ) ).

% ord_eq_le_trans
thf(fact_208_ord__eq__le__trans,axiom,
    ! [A: int,B: int,C: int] :
      ( ( A = B )
     => ( ( ord_less_eq_int @ B @ C )
       => ( ord_less_eq_int @ A @ C ) ) ) ).

% ord_eq_le_trans
thf(fact_209_ord__le__eq__trans,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( B = C )
       => ( ord_less_eq_real @ A @ C ) ) ) ).

% ord_le_eq_trans
thf(fact_210_ord__le__eq__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( B = C )
       => ( ord_less_eq_nat @ A @ C ) ) ) ).

% ord_le_eq_trans
thf(fact_211_ord__le__eq__trans,axiom,
    ! [A: int,B: int,C: int] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( B = C )
       => ( ord_less_eq_int @ A @ C ) ) ) ).

% ord_le_eq_trans
thf(fact_212_order__class_Oorder_Oantisym,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ord_less_eq_real @ B @ A )
       => ( A = B ) ) ) ).

% order_class.order.antisym
thf(fact_213_order__class_Oorder_Oantisym,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ B @ A )
       => ( A = B ) ) ) ).

% order_class.order.antisym
thf(fact_214_order__class_Oorder_Oantisym,axiom,
    ! [A: int,B: int] :
      ( ( ord_less_eq_int @ A @ B )
     => ( ( ord_less_eq_int @ B @ A )
       => ( A = B ) ) ) ).

% order_class.order.antisym
thf(fact_215_order__trans,axiom,
    ! [X: real,Y3: real,Z5: real] :
      ( ( ord_less_eq_real @ X @ Y3 )
     => ( ( ord_less_eq_real @ Y3 @ Z5 )
       => ( ord_less_eq_real @ X @ Z5 ) ) ) ).

% order_trans
thf(fact_216_order__trans,axiom,
    ! [X: nat,Y3: nat,Z5: nat] :
      ( ( ord_less_eq_nat @ X @ Y3 )
     => ( ( ord_less_eq_nat @ Y3 @ Z5 )
       => ( ord_less_eq_nat @ X @ Z5 ) ) ) ).

% order_trans
thf(fact_217_order__trans,axiom,
    ! [X: int,Y3: int,Z5: int] :
      ( ( ord_less_eq_int @ X @ Y3 )
     => ( ( ord_less_eq_int @ Y3 @ Z5 )
       => ( ord_less_eq_int @ X @ Z5 ) ) ) ).

% order_trans
thf(fact_218_dual__order_Orefl,axiom,
    ! [A: real] : ( ord_less_eq_real @ A @ A ) ).

% dual_order.refl
thf(fact_219_dual__order_Orefl,axiom,
    ! [A: nat] : ( ord_less_eq_nat @ A @ A ) ).

% dual_order.refl
thf(fact_220_dual__order_Orefl,axiom,
    ! [A: int] : ( ord_less_eq_int @ A @ A ) ).

% dual_order.refl
thf(fact_221_linorder__wlog,axiom,
    ! [P3: real > real > $o,A: real,B: real] :
      ( ! [A5: real,B4: real] :
          ( ( ord_less_eq_real @ A5 @ B4 )
         => ( P3 @ A5 @ B4 ) )
     => ( ! [A5: real,B4: real] :
            ( ( P3 @ B4 @ A5 )
           => ( P3 @ A5 @ B4 ) )
       => ( P3 @ A @ B ) ) ) ).

% linorder_wlog
thf(fact_222_linorder__wlog,axiom,
    ! [P3: nat > nat > $o,A: nat,B: nat] :
      ( ! [A5: nat,B4: nat] :
          ( ( ord_less_eq_nat @ A5 @ B4 )
         => ( P3 @ A5 @ B4 ) )
     => ( ! [A5: nat,B4: nat] :
            ( ( P3 @ B4 @ A5 )
           => ( P3 @ A5 @ B4 ) )
       => ( P3 @ A @ B ) ) ) ).

% linorder_wlog
thf(fact_223_linorder__wlog,axiom,
    ! [P3: int > int > $o,A: int,B: int] :
      ( ! [A5: int,B4: int] :
          ( ( ord_less_eq_int @ A5 @ B4 )
         => ( P3 @ A5 @ B4 ) )
     => ( ! [A5: int,B4: int] :
            ( ( P3 @ B4 @ A5 )
           => ( P3 @ A5 @ B4 ) )
       => ( P3 @ A @ B ) ) ) ).

% linorder_wlog
thf(fact_224_dual__order_Otrans,axiom,
    ! [B: real,A: real,C: real] :
      ( ( ord_less_eq_real @ B @ A )
     => ( ( ord_less_eq_real @ C @ B )
       => ( ord_less_eq_real @ C @ A ) ) ) ).

% dual_order.trans
thf(fact_225_dual__order_Otrans,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ord_less_eq_nat @ B @ A )
     => ( ( ord_less_eq_nat @ C @ B )
       => ( ord_less_eq_nat @ C @ A ) ) ) ).

% dual_order.trans
thf(fact_226_dual__order_Otrans,axiom,
    ! [B: int,A: int,C: int] :
      ( ( ord_less_eq_int @ B @ A )
     => ( ( ord_less_eq_int @ C @ B )
       => ( ord_less_eq_int @ C @ A ) ) ) ).

% dual_order.trans
thf(fact_227_dual__order_Oeq__iff,axiom,
    ( ( ^ [Y4: real,Z4: real] : ( Y4 = Z4 ) )
    = ( ^ [A2: real,B3: real] :
          ( ( ord_less_eq_real @ B3 @ A2 )
          & ( ord_less_eq_real @ A2 @ B3 ) ) ) ) ).

% dual_order.eq_iff
thf(fact_228_dual__order_Oeq__iff,axiom,
    ( ( ^ [Y4: nat,Z4: nat] : ( Y4 = Z4 ) )
    = ( ^ [A2: nat,B3: nat] :
          ( ( ord_less_eq_nat @ B3 @ A2 )
          & ( ord_less_eq_nat @ A2 @ B3 ) ) ) ) ).

% dual_order.eq_iff
thf(fact_229_dual__order_Oeq__iff,axiom,
    ( ( ^ [Y4: int,Z4: int] : ( Y4 = Z4 ) )
    = ( ^ [A2: int,B3: int] :
          ( ( ord_less_eq_int @ B3 @ A2 )
          & ( ord_less_eq_int @ A2 @ B3 ) ) ) ) ).

% dual_order.eq_iff
thf(fact_230_dual__order_Oantisym,axiom,
    ! [B: real,A: real] :
      ( ( ord_less_eq_real @ B @ A )
     => ( ( ord_less_eq_real @ A @ B )
       => ( A = B ) ) ) ).

% dual_order.antisym
thf(fact_231_dual__order_Oantisym,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_eq_nat @ B @ A )
     => ( ( ord_less_eq_nat @ A @ B )
       => ( A = B ) ) ) ).

% dual_order.antisym
thf(fact_232_dual__order_Oantisym,axiom,
    ! [B: int,A: int] :
      ( ( ord_less_eq_int @ B @ A )
     => ( ( ord_less_eq_int @ A @ B )
       => ( A = B ) ) ) ).

% dual_order.antisym
thf(fact_233_dual__order_Ostrict__implies__not__eq,axiom,
    ! [B: real,A: real] :
      ( ( ord_less_real @ B @ A )
     => ( A != B ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_234_dual__order_Ostrict__implies__not__eq,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_nat @ B @ A )
     => ( A != B ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_235_order_Ostrict__implies__not__eq,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ A @ B )
     => ( A != B ) ) ).

% order.strict_implies_not_eq
thf(fact_236_order_Ostrict__implies__not__eq,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( A != B ) ) ).

% order.strict_implies_not_eq
thf(fact_237_not__less__iff__gr__or__eq,axiom,
    ! [X: real,Y3: real] :
      ( ( ~ ( ord_less_real @ X @ Y3 ) )
      = ( ( ord_less_real @ Y3 @ X )
        | ( X = Y3 ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_238_not__less__iff__gr__or__eq,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ~ ( ord_less_nat @ X @ Y3 ) )
      = ( ( ord_less_nat @ Y3 @ X )
        | ( X = Y3 ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_239_dual__order_Ostrict__trans,axiom,
    ! [B: real,A: real,C: real] :
      ( ( ord_less_real @ B @ A )
     => ( ( ord_less_real @ C @ B )
       => ( ord_less_real @ C @ A ) ) ) ).

% dual_order.strict_trans
thf(fact_240_dual__order_Ostrict__trans,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ord_less_nat @ B @ A )
     => ( ( ord_less_nat @ C @ B )
       => ( ord_less_nat @ C @ A ) ) ) ).

% dual_order.strict_trans
thf(fact_241_linorder__less__wlog,axiom,
    ! [P3: real > real > $o,A: real,B: real] :
      ( ! [A5: real,B4: real] :
          ( ( ord_less_real @ A5 @ B4 )
         => ( P3 @ A5 @ B4 ) )
     => ( ! [A5: real] : ( P3 @ A5 @ A5 )
       => ( ! [A5: real,B4: real] :
              ( ( P3 @ B4 @ A5 )
             => ( P3 @ A5 @ B4 ) )
         => ( P3 @ A @ B ) ) ) ) ).

% linorder_less_wlog
thf(fact_242_linorder__less__wlog,axiom,
    ! [P3: nat > nat > $o,A: nat,B: nat] :
      ( ! [A5: nat,B4: nat] :
          ( ( ord_less_nat @ A5 @ B4 )
         => ( P3 @ A5 @ B4 ) )
     => ( ! [A5: nat] : ( P3 @ A5 @ A5 )
       => ( ! [A5: nat,B4: nat] :
              ( ( P3 @ B4 @ A5 )
             => ( P3 @ A5 @ B4 ) )
         => ( P3 @ A @ B ) ) ) ) ).

% linorder_less_wlog
thf(fact_243_exists__least__iff,axiom,
    ( ( ^ [P5: nat > $o] :
        ? [X6: nat] : ( P5 @ X6 ) )
    = ( ^ [P6: nat > $o] :
        ? [N2: nat] :
          ( ( P6 @ N2 )
          & ! [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
             => ~ ( P6 @ M2 ) ) ) ) ) ).

% exists_least_iff
thf(fact_244_less__imp__not__less,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_real @ X @ Y3 )
     => ~ ( ord_less_real @ Y3 @ X ) ) ).

% less_imp_not_less
thf(fact_245_less__imp__not__less,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_nat @ X @ Y3 )
     => ~ ( ord_less_nat @ Y3 @ X ) ) ).

% less_imp_not_less
thf(fact_246_order_Ostrict__trans,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ord_less_real @ A @ B )
     => ( ( ord_less_real @ B @ C )
       => ( ord_less_real @ A @ C ) ) ) ).

% order.strict_trans
thf(fact_247_order_Ostrict__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_nat @ B @ C )
       => ( ord_less_nat @ A @ C ) ) ) ).

% order.strict_trans
thf(fact_248_dual__order_Oirrefl,axiom,
    ! [A: real] :
      ~ ( ord_less_real @ A @ A ) ).

% dual_order.irrefl
thf(fact_249_dual__order_Oirrefl,axiom,
    ! [A: nat] :
      ~ ( ord_less_nat @ A @ A ) ).

% dual_order.irrefl
thf(fact_250_linorder__cases,axiom,
    ! [X: real,Y3: real] :
      ( ~ ( ord_less_real @ X @ Y3 )
     => ( ( X != Y3 )
       => ( ord_less_real @ Y3 @ X ) ) ) ).

% linorder_cases
thf(fact_251_linorder__cases,axiom,
    ! [X: nat,Y3: nat] :
      ( ~ ( ord_less_nat @ X @ Y3 )
     => ( ( X != Y3 )
       => ( ord_less_nat @ Y3 @ X ) ) ) ).

% linorder_cases
thf(fact_252_less__imp__triv,axiom,
    ! [X: real,Y3: real,P3: $o] :
      ( ( ord_less_real @ X @ Y3 )
     => ( ( ord_less_real @ Y3 @ X )
       => P3 ) ) ).

% less_imp_triv
thf(fact_253_less__imp__triv,axiom,
    ! [X: nat,Y3: nat,P3: $o] :
      ( ( ord_less_nat @ X @ Y3 )
     => ( ( ord_less_nat @ Y3 @ X )
       => P3 ) ) ).

% less_imp_triv
thf(fact_254_less__imp__not__eq2,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_real @ X @ Y3 )
     => ( Y3 != X ) ) ).

% less_imp_not_eq2
thf(fact_255_less__imp__not__eq2,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_nat @ X @ Y3 )
     => ( Y3 != X ) ) ).

% less_imp_not_eq2
thf(fact_256_antisym__conv3,axiom,
    ! [Y3: real,X: real] :
      ( ~ ( ord_less_real @ Y3 @ X )
     => ( ( ~ ( ord_less_real @ X @ Y3 ) )
        = ( X = Y3 ) ) ) ).

% antisym_conv3
thf(fact_257_antisym__conv3,axiom,
    ! [Y3: nat,X: nat] :
      ( ~ ( ord_less_nat @ Y3 @ X )
     => ( ( ~ ( ord_less_nat @ X @ Y3 ) )
        = ( X = Y3 ) ) ) ).

% antisym_conv3
thf(fact_258_less__induct,axiom,
    ! [P3: nat > $o,A: nat] :
      ( ! [X2: nat] :
          ( ! [Y5: nat] :
              ( ( ord_less_nat @ Y5 @ X2 )
             => ( P3 @ Y5 ) )
         => ( P3 @ X2 ) )
     => ( P3 @ A ) ) ).

% less_induct
thf(fact_259_less__not__sym,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_real @ X @ Y3 )
     => ~ ( ord_less_real @ Y3 @ X ) ) ).

% less_not_sym
thf(fact_260_less__not__sym,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_nat @ X @ Y3 )
     => ~ ( ord_less_nat @ Y3 @ X ) ) ).

% less_not_sym
thf(fact_261_less__imp__not__eq,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_real @ X @ Y3 )
     => ( X != Y3 ) ) ).

% less_imp_not_eq
thf(fact_262_less__imp__not__eq,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_nat @ X @ Y3 )
     => ( X != Y3 ) ) ).

% less_imp_not_eq
thf(fact_263_dual__order_Oasym,axiom,
    ! [B: real,A: real] :
      ( ( ord_less_real @ B @ A )
     => ~ ( ord_less_real @ A @ B ) ) ).

% dual_order.asym
thf(fact_264_dual__order_Oasym,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_nat @ B @ A )
     => ~ ( ord_less_nat @ A @ B ) ) ).

% dual_order.asym
thf(fact_265_ord__less__eq__trans,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ord_less_real @ A @ B )
     => ( ( B = C )
       => ( ord_less_real @ A @ C ) ) ) ).

% ord_less_eq_trans
thf(fact_266_ord__less__eq__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( B = C )
       => ( ord_less_nat @ A @ C ) ) ) ).

% ord_less_eq_trans
thf(fact_267_ord__eq__less__trans,axiom,
    ! [A: real,B: real,C: real] :
      ( ( A = B )
     => ( ( ord_less_real @ B @ C )
       => ( ord_less_real @ A @ C ) ) ) ).

% ord_eq_less_trans
thf(fact_268_ord__eq__less__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( A = B )
     => ( ( ord_less_nat @ B @ C )
       => ( ord_less_nat @ A @ C ) ) ) ).

% ord_eq_less_trans
thf(fact_269_less__irrefl,axiom,
    ! [X: real] :
      ~ ( ord_less_real @ X @ X ) ).

% less_irrefl
thf(fact_270_less__irrefl,axiom,
    ! [X: nat] :
      ~ ( ord_less_nat @ X @ X ) ).

% less_irrefl
thf(fact_271_less__linear,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_real @ X @ Y3 )
      | ( X = Y3 )
      | ( ord_less_real @ Y3 @ X ) ) ).

% less_linear
thf(fact_272_less__linear,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_nat @ X @ Y3 )
      | ( X = Y3 )
      | ( ord_less_nat @ Y3 @ X ) ) ).

% less_linear
thf(fact_273_less__trans,axiom,
    ! [X: real,Y3: real,Z5: real] :
      ( ( ord_less_real @ X @ Y3 )
     => ( ( ord_less_real @ Y3 @ Z5 )
       => ( ord_less_real @ X @ Z5 ) ) ) ).

% less_trans
thf(fact_274_less__trans,axiom,
    ! [X: nat,Y3: nat,Z5: nat] :
      ( ( ord_less_nat @ X @ Y3 )
     => ( ( ord_less_nat @ Y3 @ Z5 )
       => ( ord_less_nat @ X @ Z5 ) ) ) ).

% less_trans
thf(fact_275_less__asym_H,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ A @ B )
     => ~ ( ord_less_real @ B @ A ) ) ).

% less_asym'
thf(fact_276_less__asym_H,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ B )
     => ~ ( ord_less_nat @ B @ A ) ) ).

% less_asym'
thf(fact_277_less__asym,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_real @ X @ Y3 )
     => ~ ( ord_less_real @ Y3 @ X ) ) ).

% less_asym
thf(fact_278_less__asym,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_nat @ X @ Y3 )
     => ~ ( ord_less_nat @ Y3 @ X ) ) ).

% less_asym
thf(fact_279_less__imp__neq,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_real @ X @ Y3 )
     => ( X != Y3 ) ) ).

% less_imp_neq
thf(fact_280_less__imp__neq,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ord_less_nat @ X @ Y3 )
     => ( X != Y3 ) ) ).

% less_imp_neq
thf(fact_281_dense,axiom,
    ! [X: real,Y3: real] :
      ( ( ord_less_real @ X @ Y3 )
     => ? [Z3: real] :
          ( ( ord_less_real @ X @ Z3 )
          & ( ord_less_real @ Z3 @ Y3 ) ) ) ).

% dense
thf(fact_282_order_Oasym,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ A @ B )
     => ~ ( ord_less_real @ B @ A ) ) ).

% order.asym
thf(fact_283_order_Oasym,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ B )
     => ~ ( ord_less_nat @ B @ A ) ) ).

% order.asym
thf(fact_284_neq__iff,axiom,
    ! [X: real,Y3: real] :
      ( ( X != Y3 )
      = ( ( ord_less_real @ X @ Y3 )
        | ( ord_less_real @ Y3 @ X ) ) ) ).

% neq_iff
thf(fact_285_neq__iff,axiom,
    ! [X: nat,Y3: nat] :
      ( ( X != Y3 )
      = ( ( ord_less_nat @ X @ Y3 )
        | ( ord_less_nat @ Y3 @ X ) ) ) ).

% neq_iff
thf(fact_286_neqE,axiom,
    ! [X: real,Y3: real] :
      ( ( X != Y3 )
     => ( ~ ( ord_less_real @ X @ Y3 )
       => ( ord_less_real @ Y3 @ X ) ) ) ).

% neqE
thf(fact_287_neqE,axiom,
    ! [X: nat,Y3: nat] :
      ( ( X != Y3 )
     => ( ~ ( ord_less_nat @ X @ Y3 )
       => ( ord_less_nat @ Y3 @ X ) ) ) ).

% neqE
thf(fact_288_gt__ex,axiom,
    ! [X: real] :
    ? [X_1: real] : ( ord_less_real @ X @ X_1 ) ).

% gt_ex
thf(fact_289_gt__ex,axiom,
    ! [X: nat] :
    ? [X_1: nat] : ( ord_less_nat @ X @ X_1 ) ).

% gt_ex
thf(fact_290_lt__ex,axiom,
    ! [X: real] :
    ? [Y: real] : ( ord_less_real @ Y @ X ) ).

% lt_ex
thf(fact_291_order__less__subst2,axiom,
    ! [A: real,B: real,F: real > real,C: real] :
      ( ( ord_less_real @ A @ B )
     => ( ( ord_less_real @ ( F @ B ) @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_real @ X2 @ Y )
             => ( ord_less_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_real @ ( F @ A ) @ C ) ) ) ) ).

% order_less_subst2
thf(fact_292_order__less__subst2,axiom,
    ! [A: real,B: real,F: real > nat,C: nat] :
      ( ( ord_less_real @ A @ B )
     => ( ( ord_less_nat @ ( F @ B ) @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_real @ X2 @ Y )
             => ( ord_less_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_less_subst2
thf(fact_293_order__less__subst2,axiom,
    ! [A: nat,B: nat,F: nat > real,C: real] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_real @ ( F @ B ) @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_nat @ X2 @ Y )
             => ( ord_less_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_real @ ( F @ A ) @ C ) ) ) ) ).

% order_less_subst2
thf(fact_294_order__less__subst2,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_nat @ ( F @ B ) @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_nat @ X2 @ Y )
             => ( ord_less_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_less_subst2
thf(fact_295_order__less__subst1,axiom,
    ! [A: real,F: real > real,B: real,C: real] :
      ( ( ord_less_real @ A @ ( F @ B ) )
     => ( ( ord_less_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_real @ X2 @ Y )
             => ( ord_less_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_real @ A @ ( F @ C ) ) ) ) ) ).

% order_less_subst1
thf(fact_296_order__less__subst1,axiom,
    ! [A: real,F: nat > real,B: nat,C: nat] :
      ( ( ord_less_real @ A @ ( F @ B ) )
     => ( ( ord_less_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_nat @ X2 @ Y )
             => ( ord_less_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_real @ A @ ( F @ C ) ) ) ) ) ).

% order_less_subst1
thf(fact_297_order__less__subst1,axiom,
    ! [A: nat,F: real > nat,B: real,C: real] :
      ( ( ord_less_nat @ A @ ( F @ B ) )
     => ( ( ord_less_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_real @ X2 @ Y )
             => ( ord_less_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_less_subst1
thf(fact_298_order__less__subst1,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ ( F @ B ) )
     => ( ( ord_less_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_nat @ X2 @ Y )
             => ( ord_less_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_less_subst1
thf(fact_299_ord__less__eq__subst,axiom,
    ! [A: real,B: real,F: real > real,C: real] :
      ( ( ord_less_real @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_real @ X2 @ Y )
             => ( ord_less_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_real @ ( F @ A ) @ C ) ) ) ) ).

% ord_less_eq_subst
thf(fact_300_ord__less__eq__subst,axiom,
    ! [A: real,B: real,F: real > nat,C: nat] :
      ( ( ord_less_real @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_real @ X2 @ Y )
             => ( ord_less_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_nat @ ( F @ A ) @ C ) ) ) ) ).

% ord_less_eq_subst
thf(fact_301_ord__less__eq__subst,axiom,
    ! [A: nat,B: nat,F: nat > real,C: real] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_nat @ X2 @ Y )
             => ( ord_less_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_real @ ( F @ A ) @ C ) ) ) ) ).

% ord_less_eq_subst
thf(fact_302_ord__less__eq__subst,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_nat @ X2 @ Y )
             => ( ord_less_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_nat @ ( F @ A ) @ C ) ) ) ) ).

% ord_less_eq_subst
thf(fact_303_ord__eq__less__subst,axiom,
    ! [A: real,F: real > real,B: real,C: real] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_real @ X2 @ Y )
             => ( ord_less_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_real @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_304_ord__eq__less__subst,axiom,
    ! [A: nat,F: real > nat,B: real,C: real] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_real @ B @ C )
       => ( ! [X2: real,Y: real] :
              ( ( ord_less_real @ X2 @ Y )
             => ( ord_less_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_nat @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_305_ord__eq__less__subst,axiom,
    ! [A: real,F: nat > real,B: nat,C: nat] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_nat @ X2 @ Y )
             => ( ord_less_real @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_real @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_306_ord__eq__less__subst,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_nat @ B @ C )
       => ( ! [X2: nat,Y: nat] :
              ( ( ord_less_nat @ X2 @ Y )
             => ( ord_less_nat @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( ord_less_nat @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_307_verit__comp__simplify1_I1_J,axiom,
    ! [A: real] :
      ~ ( ord_less_real @ A @ A ) ).

% verit_comp_simplify1(1)
thf(fact_308_verit__comp__simplify1_I1_J,axiom,
    ! [A: nat] :
      ~ ( ord_less_nat @ A @ A ) ).

% verit_comp_simplify1(1)
thf(fact_309_bot__nat__0_Oextremum__strict,axiom,
    ! [A: nat] :
      ~ ( ord_less_nat @ A @ zero_zero_nat ) ).

% bot_nat_0.extremum_strict
thf(fact_310_infinite__descent0,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ( P3 @ zero_zero_nat )
     => ( ! [N3: nat] :
            ( ( ord_less_nat @ zero_zero_nat @ N3 )
           => ( ~ ( P3 @ N3 )
             => ? [M3: nat] :
                  ( ( ord_less_nat @ M3 @ N3 )
                  & ~ ( P3 @ M3 ) ) ) )
       => ( P3 @ N ) ) ) ).

% infinite_descent0
thf(fact_311_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) ).

% gr_implies_not0
thf(fact_312_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% less_zeroE
thf(fact_313_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% not_less0
thf(fact_314_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less_nat @ zero_zero_nat @ N ) )
      = ( N = zero_zero_nat ) ) ).

% not_gr0
thf(fact_315_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% gr0I
thf(fact_316_cross__def,axiom,
    ( sturm_1953858694_cross
    = ( ^ [P2: poly_real,A2: real,B3: real] : ( sturm_1279781401iation @ ( poly_real2 @ P2 @ A2 ) @ ( poly_real2 @ P2 @ B3 ) ) ) ) ).

% cross_def
thf(fact_317_nat_Oinject,axiom,
    ! [X22: nat,Y22: nat] :
      ( ( ( suc @ X22 )
        = ( suc @ Y22 ) )
      = ( X22 = Y22 ) ) ).

% nat.inject
thf(fact_318_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_319_lessI,axiom,
    ! [N: nat] : ( ord_less_nat @ N @ ( suc @ N ) ) ).

% lessI
thf(fact_320_Suc__mono,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ord_less_nat @ ( suc @ M ) @ ( suc @ N ) ) ) ).

% Suc_mono
thf(fact_321_Suc__less__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ ( suc @ M ) @ ( suc @ N ) )
      = ( ord_less_nat @ M @ N ) ) ).

% Suc_less_eq
thf(fact_322_Suc__le__mono,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_eq_nat @ ( suc @ N ) @ ( suc @ M ) )
      = ( ord_less_eq_nat @ N @ M ) ) ).

% Suc_le_mono
thf(fact_323_less__Suc0,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ N @ ( suc @ zero_zero_nat ) )
      = ( N = zero_zero_nat ) ) ).

% less_Suc0
thf(fact_324_zero__less__Suc,axiom,
    ! [N: nat] : ( ord_less_nat @ zero_zero_nat @ ( suc @ N ) ) ).

% zero_less_Suc
thf(fact_325_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ N @ one_one_nat )
      = ( N = zero_zero_nat ) ) ).

% less_one
thf(fact_326_variation__0_I2_J,axiom,
    ! [X: real] :
      ( ( sturm_1279781401iation @ X @ zero_zero_real )
      = zero_zero_int ) ).

% variation_0(2)
thf(fact_327_variation__0_I1_J,axiom,
    ! [Y3: real] :
      ( ( sturm_1279781401iation @ zero_zero_real @ Y3 )
      = zero_zero_int ) ).

% variation_0(1)
thf(fact_328_One__nat__def,axiom,
    ( one_one_nat
    = ( suc @ zero_zero_nat ) ) ).

% One_nat_def
thf(fact_329_transitive__stepwise__le,axiom,
    ! [M: nat,N: nat,R: nat > nat > $o] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ! [X2: nat] : ( R @ X2 @ X2 )
       => ( ! [X2: nat,Y: nat,Z3: nat] :
              ( ( R @ X2 @ Y )
             => ( ( R @ Y @ Z3 )
               => ( R @ X2 @ Z3 ) ) )
         => ( ! [N3: nat] : ( R @ N3 @ ( suc @ N3 ) )
           => ( R @ M @ N ) ) ) ) ) ).

% transitive_stepwise_le
thf(fact_330_nat__induct__at__least,axiom,
    ! [M: nat,N: nat,P3: nat > $o] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( P3 @ M )
       => ( ! [N3: nat] :
              ( ( ord_less_eq_nat @ M @ N3 )
             => ( ( P3 @ N3 )
               => ( P3 @ ( suc @ N3 ) ) ) )
         => ( P3 @ N ) ) ) ) ).

% nat_induct_at_least
thf(fact_331_Nat_Oex__has__greatest__nat,axiom,
    ! [P3: nat > $o,K2: nat,B: nat] :
      ( ( P3 @ K2 )
     => ( ! [Y: nat] :
            ( ( P3 @ Y )
           => ( ord_less_eq_nat @ Y @ B ) )
       => ? [X2: nat] :
            ( ( P3 @ X2 )
            & ! [Y5: nat] :
                ( ( P3 @ Y5 )
               => ( ord_less_eq_nat @ Y5 @ X2 ) ) ) ) ) ).

% Nat.ex_has_greatest_nat
thf(fact_332_verit__la__generic,axiom,
    ! [A: int,X: int] :
      ( ( ord_less_eq_int @ A @ X )
      | ( A = X )
      | ( ord_less_eq_int @ X @ A ) ) ).

% verit_la_generic
thf(fact_333_full__nat__induct,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M3: nat] :
              ( ( ord_less_eq_nat @ ( suc @ M3 ) @ N3 )
             => ( P3 @ M3 ) )
         => ( P3 @ N3 ) )
     => ( P3 @ N ) ) ).

% full_nat_induct
thf(fact_334_not__less__eq__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ~ ( ord_less_eq_nat @ M @ N ) )
      = ( ord_less_eq_nat @ ( suc @ N ) @ M ) ) ).

% not_less_eq_eq
thf(fact_335_Suc__n__not__le__n,axiom,
    ! [N: nat] :
      ~ ( ord_less_eq_nat @ ( suc @ N ) @ N ) ).

% Suc_n_not_le_n
thf(fact_336_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
      | ( ord_less_eq_nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_337_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( ord_less_eq_nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_338_le__Suc__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ ( suc @ N ) )
      = ( ( ord_less_eq_nat @ M @ N )
        | ( M
          = ( suc @ N ) ) ) ) ).

% le_Suc_eq
thf(fact_339_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_340_le__trans,axiom,
    ! [I: nat,J: nat,K2: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ( ord_less_eq_nat @ J @ K2 )
       => ( ord_less_eq_nat @ I @ K2 ) ) ) ).

% le_trans
thf(fact_341_Suc__le__D,axiom,
    ! [N: nat,M4: nat] :
      ( ( ord_less_eq_nat @ ( suc @ N ) @ M4 )
     => ? [M5: nat] :
          ( M4
          = ( suc @ M5 ) ) ) ).

% Suc_le_D
thf(fact_342_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ N @ N ) ).

% le_refl
thf(fact_343_le__SucI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ord_less_eq_nat @ M @ ( suc @ N ) ) ) ).

% le_SucI
thf(fact_344_le__SucE,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ ( suc @ N ) )
     => ( ~ ( ord_less_eq_nat @ M @ N )
       => ( M
          = ( suc @ N ) ) ) ) ).

% le_SucE

% Conjectures (1)
thf(conj_0,conjecture,
    ( ( sturm_469514713_r_pos @ p @ x )
   != ( ~ ( ( ( ( poly_real2 @ p @ x )
              = zero_zero_real )
           => ( sturm_469514713_r_pos @ ( pderiv_real @ p ) @ x ) )
          & ( ( ( poly_real2 @ p @ x )
             != zero_zero_real )
           => ( ord_less_real @ zero_zero_real @ ( poly_real2 @ p @ x ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
